from net_3tensor access *;

picture P1, P2;
network N1;
tensor box = N1.add_tensor((40, 30), 40, 30, label="$\langle n, r, n \rangle$", pen=blue);
tensor X = N1.add_tensor((17.5, -20), 17.5, 10, label="$X$", pen=green);
tensor Y = N1.add_tensor((80-17.5, -20), 17.5, 10, label="$Y$", pen=green);
for (int i = 0; i < 4; ++i) {
  N1.join(X.mid + (15-2.5*i, 0), X.mid + (15-2.5*i, 30));
  N1.join(Y.mid + (-15+2.5*i, 0), Y.mid + (-15+2.5*i, 30));
}
for (int i = 0; i < 6; ++i) {
  N1.join(X.mid + (-15+2.5*i, 0), X.mid + (-15+2.5*i, 30));
  N1.join(Y.mid + (15-2.5*i, 0), Y.mid + (15-2.5*i, 30));
  N1.join(box.mid + (-25+2.5*i, 0), box.mid + (-25+2.5*i, 40));
  N1.join(box.mid + (25-2.5*i, 0), box.mid + (25-2.5*i, 40));
}
N1.draw(P1);

network N2;
tensor box = N2.add_tensor((40, 30), 40, 30, label="$\langle c^k, c^k, c^k \rangle$", pen=blue);
tensor X = N2.add_tensor((17.5, -20), 17.5, 10, label="$X$", pen=green);
tensor Y = N2.add_tensor((80-17.5, -20), 17.5, 10, label="$Y$", pen=green);
for (int i = 0; i < 4; ++i) {
  N2.join(X.mid + (-15+2.5*i+5, 0), X.mid + (-15+2.5*i+5, 30));
  N2.join(X.mid + (15-2.5*i, 0), X.mid + (15-2.5*i, 30));
  N2.join(Y.mid + (-15+2.5*i, 0), Y.mid + (-15+2.5*i, 30));
  N2.join(Y.mid + (15-2.5*i, 0), Y.mid + (15-2.5*i, 30));
  N2.join(box.mid + (-25+2.5*i+5, 0), box.mid + (-25+2.5*i+5, 40));
  N2.join(box.mid + (25-2.5*i, 0), box.mid + (25-2.5*i, 40));
}

for (int i = 0; i < 2; ++i) {
  tensor IX = N2.add_tensor((-20+10*i, 25+12.5*i), 5.5, 5.5, label="$I_c$");
  tensor IY = N2.add_tensor((87.5+10*i, 25+12.5*i), 5.5, 5.5, label="$I_c$");
  pair px = X.mid + (-15+2.5*i, 10), ox = box.mid + (-25+2.5*i-2.5, 40);
  N2.add_path(px .. controls px + (0, 5) and (IX.mid.x, px.y+5) .. IX.mid+(0,-5.5));
  N2.add_path(IX.mid + (0,5.5) .. controls (IX.mid.x,71-5*i) and (ox.x, 62) .. ox);
  pair py = Y.mid + (15+2.5*i-12.5, 10), oy = box.mid + (10+2.5*i, 40);
  N2.add_path(py .. controls py + (0, 8) and (IY.mid.x, py.y) .. IY.mid+(0,-5.5));
  N2.add_path(IY.mid + (0,5.5) .. controls (IY.mid.x,80-4*i) and (oy.x, 60+5*i) .. oy);
}
N2.draw(P2);

label(P2, "\parbox{2.5cm}{$t-k$ modes,\\each of length $c$}", (-40, 85), RightSide, magenta+fontsize(9pt));
label(P2, xscale(0.75)*rotate(-90)*Label("\{", magenta), (13, 73));
label(P2, "\parbox{2.5cm}{$k$ modes,\\each of length $c$}", (50, 85), RightSide, magenta+fontsize(9pt));
label(P2, rotate(-90)*Label("\{", magenta), (61, 73));

add(P1, (0, 0));
add(P2, (125, 0));
draw((87, 30-1)--(93, 30-1), p=blue);
draw((87, 30+1)--(93, 30+1), p=blue);
