from net_3tensor access *;

picture P1, P2;
picture dummy;
network N1 = three_tensor(), N2 = three_tensor();
N2.draw(dummy);

pair box_mid = (min(dummy) + max(dummy))/2;
pair box_size = (max(dummy) - min(dummy))/2 + (5, -10);

N1.add_tensor(box_mid, box_size.x, box_size.y, label="$\langle c, b, c \rangle$", pen=blue);

N2.tensors[0].label = "$\alpha$";
N2.tensors[1].label = "$\beta$";
N2.tensors[2].label = "$\gamma$";

N1.draw(P1);
N2.draw(P2);
draw(P2, box_mid-box_size -- box_mid+(box_size.x,-box_size.y) -- box_mid+box_size -- box_mid+(-box_size.x,box_size.y)--cycle, p=blue);

label(P1, "$i_1$", N1.tensors[0].mid + (-5, -30), fontsize(7pt));
label(P1, "$k_1$", N1.tensors[0].mid + (5, -30), fontsize(7pt));

label(P1, "$k_2$", N1.tensors[1].mid + (-5, -30), fontsize(7pt));
label(P1, "$j_1$", N1.tensors[1].mid + (5, -30), fontsize(7pt));

label(P1, "$i_2$", N1.tensors[2].mid + (-5, 30), fontsize(7pt));
label(P1, "$j_2$", N1.tensors[2].mid + (5, 30), fontsize(7pt));

for (int i = 0; i < 3; ++i) {
  int delta = i < 2 ? 7 : -7;
  label(P2, "0", N2.tensors[i].mid + (-5, -delta), magenta+fontsize(6pt));
  label(P2, "1", N2.tensors[i].mid + (5, -delta), magenta+fontsize(6pt));
  label(P2, "2", N2.tensors[i].mid + (0, delta), magenta+fontsize(6pt));
}
      
add(P1, (0, 0));
add(P2, (100, 0));
draw((72, box_mid.y-1)--(78, box_mid.y-1), p=blue);
draw((72, box_mid.y+1)--(78, box_mid.y+1), p=blue);
