from networks access *;

network N;

real W = (25*5+20)/2;
tensor mul = N.add_tensor((W, 50), W, 10, label="$\langle n^{l/2}, r, n^{l/2} \rangle$", pen=blue);

tensor A[] = new tensor[];
for (int i = 0; i < 6; ++i) {
  A[i+1] = N.add_tensor((25*i+10, 0), 10, 10, label="$A^{(" + string(i+1) + ")}$", pen=green);
}

mode_join u = N.add_mode_join(A[1].mid + (25, 28));
mode_join v = N.add_mode_join(A[6].mid + (-25, 28));

N.join(u.mid, u.mid + (0, 20));
N.join(v.mid, v.mid + (0, 20));

for (int i = 1; i <= 3; ++i) {
  pair end = A[1].mid + (-5+7.5*(i-1), 25);
  N.add_path(smooth_vertical_path(A[i].mid + (-5, 10), end) -- end+(0, 15));
  N.add_path(smooth_vertical_path(A[i].mid + (5, 10), u.mid));
  N.join(mul.mid + (-25+5*i, 0), mul.mid + (-25+5*i, 20));
  N.join(mul.mid + (25-5*i, 0), mul.mid + (25-5*i, 20));
}
for (int i = 4; i <= 6; ++i) {
  pair end = A[6].mid + (5-7.5*(6-i), 25);
  N.add_path(smooth_vertical_path(A[i].mid + (-5, 10), end) -- end+(0,15));
  N.add_path(smooth_vertical_path(A[i].mid + (5, 10), v.mid));
}


N.draw();
